<?php
require 'config.php';
session_start();

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $stmt = $db->prepare("SELECT * FROM `servers` WHERE `type` = ?");
    $type = 'مرزبان';
    $stmt->bind_param("s", $type);
    $stmt->execute();
    $panel = $stmt->get_result()->fetch_assoc();

    if (!$panel) {
        $error = "Panel config not found.";
    } else {

        if ($_POST['username'] !== $panel['user'] || $_POST['password'] !== $panel['pass']) {
            $error = "Invalid username or password.";
        } else {

            $stmt2 = $db->prepare("SELECT * FROM `tokens` WHERE `panel` = ?");
            $panelName = 'مرزبان';
            $stmt2->bind_param("s", $panelName);
            $stmt2->execute();
            $login = $stmt2->get_result()->fetch_assoc();

            if (!empty($login['token'])) {
                $_SESSION['token'] = $login['token'];
                $_SESSION['admin'] = true;
                header("Location: index.php");
                exit;
            } else {
                $error = "Token not found.";
            }
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Admin Login</title>

<style>
body {
    margin: 0;
    height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
    background: linear-gradient(135deg, #2c3e50, #4ca1af);
    font-family: Arial, sans-serif;
}

.login-box {
    background: #fff;
    padding: 40px;
    width: 320px;
    border-radius: 10px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.2);
}

h2 {
    text-align: center;
    margin-bottom: 25px;
}

input {
    width: 100%;
    padding: 10px;
    margin-bottom: 15px;
    border-radius: 6px;
    border: 1px solid #ccc;
    box-sizing: border-box;
}

input:focus {
    outline: none;
    border-color: #3498db;
}

button {
    width: 100%;
    padding: 10px;
    border: none;
    border-radius: 6px;
    background: #3498db;
    color: white;
    font-weight: bold;
    cursor: pointer;
}

button:hover {
    background: #2980b9;
}

.error {
    background: #e74c3c;
    color: white;
    padding: 8px;
    border-radius: 6px;
    margin-bottom: 15px;
    text-align: center;
}
</style>
</head>

<body>

<div class="login-box">

<h2>Admin Login</h2>

<?php if ($error): ?>
    <div class="error"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<form method="post">
    <input type="text" name="username" placeholder="Username" required>
    <input type="password" name="password" placeholder="Password" required>
    <button type="submit">Login</button>
</form>

</div>

</body>
</html>