<?php
require 'config.php';
if (!isset($_SESSION['admin'])) 
{
    header("Location: login.php");
    exit;
}
$users = apiRequest('GET', '/api/users');
$now = time();
if (isset($_POST['delete']) && !empty($_POST['selected'])) 
{
    foreach ($_POST['selected'] as $username) apiRequest('DELETE', '/api/user/' . $username);
}
if (isset($_POST['extend']) && !empty($_POST['selected'])) 
{
    $days = intval($_POST['extend_days']);
    foreach ($_POST['selected'] as $username) 
    {
        $user = apiRequest('GET', '/api/user/' . $username);
        $newExpire = $user['expire'] + ($days * 86400);
        apiRequest('PUT', '/api/user/' . $username, ['expire' => $newExpire]);
    }
}
if (isset($_POST['add_volume']) && !empty($_POST['selected'])) 
{
    $gb = intval($_POST['volume_gb']);
    foreach ($_POST['selected'] as $username) 
    {
        $user = apiRequest('GET', '/api/user/' . $username);
        $newLimit = $user['data_limit'] + ($gb * 1024 * 1024 * 1024);
        apiRequest('PUT', '/api/user/' . $username, ['data_limit' => $newLimit]);
    }
}
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Admin Panel</title>
<style>
body {
    font-family: Arial, sans-serif;
    background: #f4f6f9;
    padding: 30px;
}
h2 {
    margin-bottom: 20px;
}
table {
    width: 100%;
    border-collapse: collapse;
    background: #fff;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 4px 10px rgba(0,0,0,0.05);
}
th {
    background: #2c3e50;
    color: white;
    padding: 12px;
    text-align: left;
}
td {
    padding: 12px;
    border-bottom: 1px solid #eee;
    transition: 0.2s;
}
tr:hover {
    background: #f5f7fa;
}
tr.expired {
    background: #ffe6e6;
}
tr.expired td {
    color: #c0392b;
    font-weight: bold;
}
tr.selected-row {
    background: #d6eaff !important;
}
.actions {
    margin-top: 20px;
    background: #fff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.05);
}
input[type="number"] {
    padding: 8px;
    width: 80px;
    margin-right: 10px;
}
button {
    padding: 8px 14px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-weight: bold;
    margin-right: 10px;
}
.delete-btn {
    background: #e74c3c;
    color: white;
}
.extend-btn {
    background: #3498db;
    color: white;
}
.volume-btn {
    background: #27ae60;
    color: white;
}
.logout {
    display: inline-block;
    margin-top: 20px;
    text-decoration: none;
    color: #555;
}
</style>
</head>
<body>
<h2>Users Management (Code by : @SeniorMehdy)</h2>
<form method="post">
<table>
<tr>
    <th>Select</th>
    <th>Username</th>
    <th>Expire</th>
    <th>Used</th>
    <th>Limit</th>
</tr>
<?php foreach ($users['users'] as $user): 
    $isExpired = ($user['expire'] < $now);
    $isFull = ($user['data_limit'] > 0 && $user['used_traffic'] >= $user['data_limit']);
    $rowClass = ($isExpired || $isFull) ? 'expired' : '';
?>
<tr class="<?= $rowClass ?>">
    <td><input type="checkbox" name="selected[]" value="<?= $user['username'] ?>"></td>
    <td><?= $user['username'] ?></td>
    <td><?= date('Y-m-d H:i', $user['expire']) ?></td>
    <td><?= round($user['used_traffic'] / 1073741824, 2) ?> GB</td>
    <td><?= round($user['data_limit'] / 1073741824, 2) ?> GB</td>
</tr>
<?php endforeach; ?>
</table>
<div class="actions">
    <button class="delete-btn" name="delete">Delete Selected</button>
    <br><br>
    Extend:
    <input type="number" name="extend_days" placeholder="Days" min="1">
    <button class="extend-btn" name="extend">Apply</button>
    <br><br>
    Add Volume:
    <input type="number" name="volume_gb" placeholder="GB" min="1">
    <button class="volume-btn" name="add_volume">Apply</button>
</div>
</form>
<a class="logout" href="logout.php">Logout</a>
<script>
document.querySelectorAll('input[type="checkbox"]').forEach(cb => {
    cb.addEventListener('change', function() {
        const row = this.closest('tr');
        if (this.checked) {
            row.classList.add('selected-row');
        } else {
            row.classList.remove('selected-row');
        }
    });
});
</script>
</body>
</html>