<?php
// ======================================================= //
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions/main.php';
// ======================================================= //
function login($address, $username, $password) 
{
    $curlOptions = 
    [
        CURLOPT_URL            => $address . '/login',
        CURLOPT_COOKIESESSION  => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING       => '',
        CURLOPT_MAXREDIRS      => 10,
        CURLOPT_TIMEOUT        => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST  => 'POST',
        CURLOPT_POSTFIELDS     => http_build_query(['username' => $username, 'password' => $password]),
        CURLOPT_HEADER         => true,
    ];
    $curl = curl_init();
    curl_setopt_array($curl, $curlOptions);
    $response = curl_exec($curl);
    $headerSize = curl_getinfo($curl, CURLINFO_HEADER_SIZE);
    $header = substr($response, 0, $headerSize);
    preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $header, $matches);
    $cookies = array();
    foreach($matches[1] as $item) 
    {
        parse_str($item, $cookie);
        $cookies = array_merge($cookies, $cookie);
    }
    curl_close($curl);
    return !empty($cookies) ? [true, reset($cookies)] : [false, $response];
}
// ======================================================= //
$panel = mysqli_fetch_assoc($db->query("SELECT * FROM `servers` WHERE `type` = 'ثنایی'"));
// ======================================================= //
if ($panel['status'] === 'off') exit('Server is off');
// ======================================================= //
$login = login($panel['url'], $panel['user'], $panel['pass']);
if ($login[0] == false)
{
    sendMessage(LOG, "❌ Error in login!!!!\n🔗 Panel : ثنایی\n📖 Response : {$login[1]}\n\n❗️ Panel Terned OFF!!!!!");
    $db->query("UPDATE `servers` SET `status` = 'off' WHERE `type` = 'ثنایی'");
    exit('Error in login');
}
sendMessage(LOG, '✅ Token for ثنایی updated successfully!');
$db->query("UPDATE `tokens` SET `token` = '{$login[1]}' WHERE `panel` = 'ثنایی'");
exit('Token updated successfully');