<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لیست کاربران</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f7fa;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background-color: #fff;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            width: 80%;
            max-width: 600px;
            padding: 20px;
            text-align: center;
        }
        .title {
            font-size: 24px;
            color: #333;
            margin-bottom: 20px;
        }
        .form-container {
            margin-bottom: 20px;
        }
        input[type="number"] {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            width: 50%;
            margin-bottom: 10px;
        }
        input[type="submit"] {
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .user-list {
            text-align: left;
            margin-bottom: 20px;
        }
        .user-item {
            background-color: #f9f9f9;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }
        .user-item:nth-child(odd) {
            background-color: #eef2f5;
        }
        .user-info {
            color: #555;
        }
        .user-info b {
            color: #333;
        }
        .footer {
            margin-top: 20px;
            font-size: 14px;
            color: #888;
        }
        .footer b {
            color: #333;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="title">لیست کاربران بر اساس موجودی</div>
        <div class="form-container">
            <form method="GET" action="">
                <label for="limit">مقدار نمایش کاربران را وارد کنید:</label><br>
                <input type="number" name="limit" id="limit" min="1" placeholder="مثلاً 10" required>
                <input type="submit" value="نمایش">
            </form>
        </div>
        <?php
        require_once __DIR__ . '/../config.php';
        if (isset($_GET['limit']) && is_numeric($_GET['limit']) && $_GET['limit'] > 0) $limit = $_GET['limit'];
        else $limit = 10;
        $user_sql = $db->query("SELECT * FROM `user` ORDER BY `balance` DESC LIMIT $limit");
        $n = 0;
        echo '<div class="user-list">';
        foreach ($user_sql as $user) 
        {
            $n += 1;
            echo '<div class="user-item">';
            echo '<div class="user-info">';
            echo $n . '- <b>ID:</b> ' . $user['row'] . ' | <b>USER ID:</b> ' . $user['from_id'] . ' | <b>BALANCE:</b> ' . number_format($user['balance']);
            echo '</div>';
            echo '</div>';
        }
        echo '</div>';
        ?>
        <div class="footer"><b>Code By : @SeniorMehdy</b></div>
    </div>
</body>
</html>