<?php
session_start();
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../functions/main.php';

// ============= توابع کمکی =============
/**
 * فوروارد کردن پیام از کانال تلگرام به کاربر
 */
function forwardTelegramPost($user_id, $telegram_link) {
    global $db;
    
    // پارس کردن لینک تلگرام
    if (!preg_match('/https?:\/\/t\.me\/([^\/]+)\/(\d+)/', $telegram_link, $matches)) {
        return ['success' => false, 'message' => '❌ فرمت لینک تلگرام صحیح نیست. مثال: https://t.me/FO_VPN/1834'];
    }
    
    $channel_username = $matches[1];
    $message_id = intval($matches[2]);
    
    // تبدیل username به chat_id عددی
    $chat_id_str = '@' . $channel_username;
    $chat_info = MahdyBots('getChat', ['chat_id' => $chat_id_str]);
    
    if (!isset($chat_info->result->id)) {
        return ['success' => false, 'message' => '❌ کانال یافت نشد یا ربات به آن دسترسی ندارد. لطفا مطمئن شوید ربات عضو کانال است یا کانال عمومی است.'];
    }
    
    $channel_id = $chat_info->result->id;
    $result = ForwardMessage($user_id, $channel_id, $message_id);
    
    if (isset($result->ok) && $result->ok) {
        return ['success' => true, 'message' => "✅ پیام با موفقیت برای کاربر $user_id فوروارد شد"];
    } else {
        return ['success' => false, 'message' => "❌ خطا در فوروارد پیام: " . ($result->description ?? 'خطای نامشخص')];
    }
}

/**
 * ارسال پیام متنی به کاربر
 */
function sendTextMessage($user_id, $text) {
    $result = sendMessage($user_id, $text, 'HTML');
    
    if (isset($result->ok) && $result->ok) {
        return ['success' => true, 'message' => "✅ پیام با موفقیت برای کاربر $user_id ارسال شد"];
    } else {
        return ['success' => false, 'message' => "❌ خطا در ارسال پیام: " . ($result->description ?? 'خطای نامشخص')];
    }
}

/**
 * تنظیم ارسال همگانی از لینک تلگرام
 */
function setupBroadcastTelegramPost($telegram_link, $admin_id) {
    global $db;
    
    // بررسی وجود پیام در صف
    $send_check = mysqli_fetch_assoc($db->query("SELECT * FROM `send`"));
    if (isset($send_check['step'])) {
        return ['success' => false, 'message' => '⚠️ یک پیام همگانی در صف ارسال قرار دارد. لطفا صبر کنید یا آن را لغو کنید'];
    }
    
    // پارس کردن لینک تلگرام
    if (!preg_match('/https?:\/\/t\.me\/([^\/]+)\/(\d+)/', $telegram_link, $matches)) {
        return ['success' => false, 'message' => '❌ فرمت لینک تلگرام صحیح نیست. مثال: https://t.me/FO_VPN/1834'];
    }
    
    $channel_username = $matches[1];
    $message_id = intval($matches[2]);
    
    // تبدیل username به chat_id عددی
    $chat_id_str = '@' . $channel_username;
    $chat_info = MahdyBots('getChat', ['chat_id' => $chat_id_str]);
    
    if (!isset($chat_info->result->id)) {
        return ['success' => false, 'message' => '❌ کانال یافت نشد یا ربات به آن دسترسی ندارد. لطفا مطمئن شوید ربات عضو کانال است یا کانال عمومی است.'];
    }
    
    $channel_id = $chat_info->result->id;
    
    // ذخیره در دیتابیس برای ارسال همگانی
    $channel_id_escaped = mysqli_real_escape_string($db, $channel_id);
    $db->query("INSERT INTO `send` (`step`, `text`, `from`, `user`) VALUES ('for', '$message_id', '$channel_id_escaped', 0)");
    
    $countUsers = mysqli_num_rows($db->query("SELECT * FROM `user`"));
    $sendTime = round($countUsers / 100);
    
    return ['success' => true, 'message' => "✅ پیام همگانی با موفقیت تنظیم شد! ارسال برای تقریباً $countUsers کاربر حدوداً $sendTime دقیقه طول می‌کشد."];
}

/**
 * تنظیم ارسال همگانی از متن سفارشی
 */
function setupBroadcastText($text, $admin_id) {
    global $db;
    
    // بررسی وجود پیام در صف
    $send_check = mysqli_fetch_assoc($db->query("SELECT * FROM `send`"));
    if (isset($send_check['step'])) {
        return ['success' => false, 'message' => '⚠️ یک پیام همگانی در صف ارسال قرار دارد. لطفا صبر کنید یا آن را لغو کنید'];
    }
    
    // ارسال یک پیام تست و ذخیره message_id
    $test_result = sendMessage($admin_id, $text, 'HTML');
    if (!isset($test_result->ok) || !$test_result->ok) {
        return ['success' => false, 'message' => "❌ خطا در ایجاد پیام تست: " . ($test_result->description ?? 'خطای نامشخص')];
    }
    
    $test_message_id = $test_result->result->message_id;
    $db->query("INSERT INTO `send` (`step`, `text`, `from`, `user`) VALUES ('send', '$test_message_id', '$admin_id', 0)");
    
    $countUsers = mysqli_num_rows($db->query("SELECT * FROM `user`"));
    $sendTime = round($countUsers / 100);
    
    return ['success' => true, 'message' => "✅ پیام همگانی با موفقیت تنظیم شد! ارسال برای تقریباً $countUsers کاربر حدوداً $sendTime دقیقه طول می‌کشد."];
}

// ============= احراز هویت =============
$admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : (isset($_GET['admin_id']) ? intval($_GET['admin_id']) : 0);

if (isset($_GET['admin_id']) && $admin_id > 0) {
    $_SESSION['admin_id'] = $admin_id;
}

if ($admin_id == 0) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login_admin_id'])) {
        $admin_id = intval($_POST['admin_id']);
        if ($admin_id > 0) {
            $admin_check = $db->query("SELECT * FROM `settings` WHERE `type` = 'admin' AND `type_id` = '$admin_id'");
            if (mysqli_num_rows($admin_check) > 0) {
                $_SESSION['admin_id'] = $admin_id;
                header('Location: ' . $_SERVER['PHP_SELF']);
                exit;
            } else {
                $login_error = '❌ شما ادمین نیستید';
            }
        } else {
            $login_error = '❌ آیدی ادمین معتبر نیست';
        }
    }
    
    // نمایش صفحه لاگین
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>ورود به پنل ارسال پیام</title>
        <style>
            body {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .login-box {
                background: white;
                padding: 40px;
                border-radius: 15px;
                box-shadow: 0 10px 40px rgba(0,0,0,0.2);
                max-width: 400px;
                width: 100%;
            }
            .login-box h1 {
                text-align: center;
                color: #667eea;
                margin-bottom: 30px;
            }
            .form-group {
                margin-bottom: 20px;
            }
            .form-group label {
                display: block;
                margin-bottom: 8px;
                color: #333;
            }
            .form-group input {
                width: 100%;
                padding: 12px;
                border: 2px solid #e0e0e0;
                border-radius: 8px;
                font-size: 16px;
            }
            .btn {
                width: 100%;
                padding: 12px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                border: none;
                border-radius: 8px;
                font-size: 16px;
                cursor: pointer;
            }
            .error {
                background: #f8d7da;
                color: #721c24;
                padding: 10px;
                border-radius: 5px;
                margin-bottom: 20px;
            }
        </style>
    </head>
    <body>
        <div class="login-box">
            <h1>🔐 ورود به پنل</h1>
            <?php if (isset($login_error)): ?>
                <div class="error"><?= $login_error ?></div>
            <?php endif; ?>
            <form method="POST">
                <input type="hidden" name="login_admin_id" value="1">
                <div class="form-group">
                    <label>آیدی عددی ادمین:</label>
                    <input type="number" name="admin_id" required placeholder="مثال: 123456789">
                </div>
                <button type="submit" class="btn">ورود</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// بررسی ادمین بودن
$admin_check = $db->query("SELECT * FROM `settings` WHERE `type` = 'admin' AND `type_id` = '$admin_id'");
if (mysqli_num_rows($admin_check) == 0) {
    die('❌ شما ادمین نیستید');
}
$admin_data = mysqli_fetch_assoc($admin_check);

// ============= پردازش درخواست‌ها =============
$success = $_SESSION['flash_success'] ?? '';
$error = $_SESSION['flash_error'] ?? '';
unset($_SESSION['flash_success'], $_SESSION['flash_error']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    // ارسال تکی
    if ($action === 'send_single') {
        $user_id = intval($_POST['user_id'] ?? 0);
        $message_type = $_POST['message_type'] ?? 'text';
        $telegram_link = trim($_POST['telegram_link'] ?? '');
        $custom_text = trim($_POST['custom_text'] ?? '');
        
        if ($user_id == 0) {
            $error = '❌ لطفا آیدی کاربر را وارد کنید';
        } else {
            // بررسی وجود کاربر
            $user_check = $db->query("SELECT * FROM `user` WHERE `from_id` = '$user_id'");
            if (mysqli_num_rows($user_check) == 0) {
                $error = '❌ کاربر یافت نشد';
            } else {
                if ($message_type === 'telegram_link' && !empty($telegram_link)) {
                    $result = forwardTelegramPost($user_id, $telegram_link);
                    if ($result['success']) {
                        $success = $result['message'];
                    } else {
                        $error = $result['message'];
                    }
                } elseif ($message_type === 'custom' && !empty($custom_text)) {
                    $result = sendTextMessage($user_id, $custom_text);
                    if ($result['success']) {
                        $success = $result['message'];
                    } else {
                        $error = $result['message'];
                    }
                } else {
                    $error = '❌ لطفا لینک تلگرام یا متن پیام را وارد کنید';
                }
            }
        }
    }
    
    // ارسال همگانی
    if ($action === 'send_broadcast') {
        $message_type = $_POST['broadcast_type'] ?? 'text';
        $telegram_link = trim($_POST['broadcast_telegram_link'] ?? '');
        $custom_text = trim($_POST['broadcast_custom_text'] ?? '');
        
        if ($message_type === 'telegram_link' && !empty($telegram_link)) {
            $result = setupBroadcastTelegramPost($telegram_link, $admin_id);
            if ($result['success']) {
                $success = $result['message'];
            } else {
                $error = $result['message'];
            }
        } elseif ($message_type === 'custom' && !empty($custom_text)) {
            $result = setupBroadcastText($custom_text, $admin_id);
            if ($result['success']) {
                $success = $result['message'];
            } else {
                $error = $result['message'];
            }
        } else {
            $error = '❌ لطفا لینک تلگرام یا متن پیام را وارد کنید';
        }
    }
    
    // لغو ارسال همگانی
    if ($action === 'cancel_broadcast') {
        $db->query("DELETE FROM `send` WHERE 1");
        $success = '✅ ارسال همگانی با موفقیت لغو شد';
    }

    // اجرای الگوی POST/Redirect/GET برای جلوگیری از اجرای دوباره درخواست در رفرش صفحه
    if ($success || $error) {
        $_SESSION['flash_success'] = $success;
        $_SESSION['flash_error'] = $error;
        header('Location: ' . $_SERVER['REQUEST_URI']);
        exit;
    }
}

// ============= دریافت آمار و اطلاعات =============
$total_users = mysqli_num_rows($db->query("SELECT * FROM `user`"));
$online_users = mysqli_num_rows($db->query("SELECT * FROM `user` WHERE `update_at` > " . (time() - 3600)));
$blocked_users = mysqli_num_rows($db->query("SELECT * FROM `block`"));
$today_users = mysqli_num_rows($db->query("SELECT * FROM `user` WHERE `started` LIKE '" . date('Y/m/d') . "%'"));

// بررسی وضعیت پیام همگانی
$send_status = mysqli_fetch_assoc($db->query("SELECT * FROM `send`"));
$broadcast_active = isset($send_status['step']);
$broadcast_progress = $broadcast_active ? $send_status['user'] : 0;
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ارسال پیام تکی و همگانی</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            font-size: 28px;
            margin-bottom: 10px;
        }
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            padding: 30px;
            background: #f8f9fa;
        }
        .stat-box {
            background: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        .stat-box:hover {
            transform: translateY(-5px);
        }
        .stat-box h3 {
            color: #667eea;
            font-size: 32px;
            margin-bottom: 10px;
        }
        .stat-box p {
            color: #666;
            font-size: 14px;
        }
        .content {
            padding: 30px;
        }
        .tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 30px;
            border-bottom: 2px solid #e0e0e0;
        }
        .tab {
            padding: 15px 30px;
            background: none;
            border: none;
            cursor: pointer;
            font-size: 16px;
            color: #666;
            border-bottom: 3px solid transparent;
            transition: all 0.3s;
        }
        .tab.active {
            color: #667eea;
            border-bottom-color: #667eea;
            font-weight: bold;
        }
        .tab-content {
            display: none;
        }
        .tab-content.active {
            display: block;
        }
        .form-group {
            margin-bottom: 25px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
        }
        .form-group input,
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        .form-group input:focus,
        .form-group textarea:focus,
        .form-group select:focus {
            outline: none;
            border-color: #667eea;
        }
        .form-group textarea {
            min-height: 120px;
            resize: vertical;
        }
        .radio-group {
            display: flex;
            gap: 20px;
            margin-top: 10px;
        }
        .radio-option {
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .radio-option input[type="radio"] {
            width: auto;
        }
        .btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 40px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            transition: transform 0.3s, box-shadow 0.3s;
            width: 100%;
            font-weight: 600;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
        .broadcast-status {
            background: #fff3cd;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #ffc107;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .example {
            background: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
            margin-top: 5px;
            font-size: 12px;
            color: #666;
        }
        .btn-cancel {
            background: #dc3545;
            padding: 8px 20px;
            font-size: 14px;
            width: auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>📫 پنل ارسال پیام تکی و همگانی</h1>
            <p>ارسال پیام به کاربران ربات</p>
        </div>
        
        <div class="stats">
            <div class="stat-box">
                <h3><?= number_format($total_users) ?></h3>
                <p>👥 کل کاربران</p>
            </div>
            <div class="stat-box">
                <h3><?= number_format($online_users) ?></h3>
                <p>🟢 کاربران آنلاین (ساعت گذشته)</p>
            </div>
            <div class="stat-box">
                <h3><?= number_format($blocked_users) ?></h3>
                <p>🚫 کاربران بلاک شده</p>
            </div>
            <div class="stat-box">
                <h3><?= number_format($today_users) ?></h3>
                <p>📅 کاربران جدید امروز</p>
            </div>
        </div>
        
        <div class="content">
            <?php if ($broadcast_active): ?>
            <div class="broadcast-status">
                <div>
                    <strong>⚠️ پیام همگانی در حال ارسال است</strong><br>
                    <small>تعداد کاربران ارسال شده: <?= number_format($broadcast_progress) ?> از <?= number_format($total_users) ?></small>
                </div>
                <form method="POST" style="display: inline;">
                    <input type="hidden" name="action" value="cancel_broadcast">
                    <button type="submit" class="btn btn-cancel" onclick="return confirm('آیا مطمئن هستید که می‌خواهید ارسال همگانی را لغو کنید؟')">لغو ارسال</button>
                </form>
            </div>
            <?php endif; ?>
            
            <?php if ($success): ?>
            <div class="alert alert-success"><?= $success ?></div>
            <?php endif; ?>
            
            <?php if ($error): ?>
            <div class="alert alert-error"><?= $error ?></div>
            <?php endif; ?>
            
            <div class="tabs">
                <button class="tab active" onclick="showTab('single')">📨 ارسال تکی</button>
                <button class="tab" onclick="showTab('broadcast')">📢 ارسال همگانی</button>
            </div>
            
            <div id="single" class="tab-content active">
                <form method="POST">
                    <input type="hidden" name="action" value="send_single">
                    
                    <div class="form-group">
                        <label>👤 آیدی عددی کاربر:</label>
                        <input type="number" name="user_id" required placeholder="مثال: 123456789">
                        <div class="example">آیدی عددی کاربر را وارد کنید</div>
                    </div>
                    
                    <div class="form-group">
                        <label>📝 نوع پیام:</label>
                        <div class="radio-group">
                            <div class="radio-option">
                                <input type="radio" name="message_type" value="telegram_link" id="type_link" checked onchange="toggleMessageType()">
                                <label for="type_link">🔗 لینک پست تلگرام</label>
                            </div>
                            <div class="radio-option">
                                <input type="radio" name="message_type" value="custom" id="type_custom" onchange="toggleMessageType()">
                                <label for="type_custom">✏️ متن سفارشی</label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group" id="telegram_link_group">
                        <label>🔗 لینک پست تلگرام:</label>
                        <input type="text" name="telegram_link" placeholder="https://t.me/FO_VPN/1834">
                        <div class="example">لینک پست تلگرام را وارد کنید. مثال: https://t.me/FO_VPN/1834</div>
                    </div>
                    
                    <div class="form-group" id="custom_text_group" style="display: none;">
                        <label>✏️ متن پیام:</label>
                        <textarea name="custom_text" placeholder="متن پیام خود را وارد کنید..."></textarea>
                    </div>
                    
                    <button type="submit" class="btn">✅ ارسال پیام</button>
                </form>
            </div>
            
            <div id="broadcast" class="tab-content">
                <form method="POST">
                    <input type="hidden" name="action" value="send_broadcast">
                    
                    <div class="form-group">
                        <label>📝 نوع پیام:</label>
                        <div class="radio-group">
                            <div class="radio-option">
                                <input type="radio" name="broadcast_type" value="telegram_link" id="broadcast_type_link" checked onchange="toggleBroadcastType()">
                                <label for="broadcast_type_link">🔗 لینک پست تلگرام</label>
                            </div>
                            <div class="radio-option">
                                <input type="radio" name="broadcast_type" value="custom" id="broadcast_type_custom" onchange="toggleBroadcastType()">
                                <label for="broadcast_type_custom">✏️ متن سفارشی</label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group" id="broadcast_telegram_link_group">
                        <label>🔗 لینک پست تلگرام:</label>
                        <input type="text" name="broadcast_telegram_link" placeholder="https://t.me/FO_VPN/1834">
                        <div class="example">لینک پست تلگرام را وارد کنید. محتوای این پست برای تمام کاربران فوروارد خواهد شد.</div>
                    </div>
                    
                    <div class="form-group" id="broadcast_custom_text_group" style="display: none;">
                        <label>✏️ متن پیام:</label>
                        <textarea name="broadcast_custom_text" placeholder="متن پیام خود را وارد کنید..."></textarea>
                        <div class="example">این متن برای تمام کاربران ارسال خواهد شد.</div>
                    </div>
                    
                    <div class="alert alert-info">
                        <strong>⚠️ توجه:</strong> ارسال همگانی به صورت خودکار انجام می‌شود و ممکن است چند دقیقه طول بکشد. لطفا صبور باشید.
                    </div>
                    
                    <button type="submit" class="btn" <?= $broadcast_active ? 'disabled' : '' ?>>
                        <?= $broadcast_active ? '⏳ در حال ارسال...' : '✅ ارسال همگانی' ?>
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <script>
        function showTab(tabName) {
            // پنهان کردن تمام تب‌ها
            document.querySelectorAll('.tab-content').forEach(tab => {
                tab.classList.remove('active');
            });
            document.querySelectorAll('.tab').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // نمایش تب انتخاب شده
            document.getElementById(tabName).classList.add('active');
            event.target.classList.add('active');
        }
        
        function toggleMessageType() {
            const linkType = document.getElementById('type_link').checked;
            document.getElementById('telegram_link_group').style.display = linkType ? 'block' : 'none';
            document.getElementById('custom_text_group').style.display = linkType ? 'none' : 'block';
        }
        
        function toggleBroadcastType() {
            const linkType = document.getElementById('broadcast_type_link').checked;
            document.getElementById('broadcast_telegram_link_group').style.display = linkType ? 'block' : 'none';
            document.getElementById('broadcast_custom_text_group').style.display = linkType ? 'none' : 'block';
        }
    </script>
</body>
</html>
