<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") 
{
    require_once __DIR__ . '/../config.php';
    $traffick  = $_POST['traffick'];
    $time      = $_POST['time'];
    $config    = $_POST['config'];
    $config_qr = null;
    if (isset($_FILES['config_qr']) && $_FILES['config_qr']['error'] === UPLOAD_ERR_OK) $config_qr = file_get_contents($_FILES['config_qr']['tmp_name']);
    $stmt = $db->prepare("INSERT INTO vpns (traffick, time, config, config_qr) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("sssb", $traffick, $time, $config, $config_qr);
    if ($stmt->execute()) $message = "اطلاعات با موفقیت ذخیره شد.";
    else $message = "خطا در ذخیره اطلاعات: " . $stmt->error;
    $stmt->close();
    $db->close();
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
  <meta charset="UTF-8">
  <title>افزودن VPN</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: Arial, sans-serif;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      background-color: #f5f5f5;
    }

    form {
      background-color: #fff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      max-width: 400px;
      width: 100%;
    }

    h2 {
      text-align: center;
      margin-bottom: 20px;
      color: #333;
    }

    label {
      display: block;
      margin-bottom: 5px;
      color: #555;
    }

    input[type="text"],
    input[type="file"] {
      width: 100%;
      padding: 10px;
      margin-bottom: 15px;
      border: 1px solid #ddd;
      border-radius: 5px;
      font-size: 14px;
    }

    input[type="submit"] {
      width: 100%;
      padding: 10px;
      border: none;
      background-color: #4CAF50;
      color: white;
      font-size: 16px;
      border-radius: 5px;
      cursor: pointer;
      transition: background-color 0.3s;
    }

    input[type="submit"]:hover {
      background-color: #45a049;
    }

    .message {
      text-align: center;
      margin-top: 20px;
      color: #333;
    }
  </style>
</head>
<body>
  <form action="" method="post" enctype="multipart/form-data">
    <h2>فرم افزودن VPN</h2>
    <label for="traffick">ترافیک:</label>
    <input type="text" id="traffick" name="traffick" required>
    <label for="time">زمان:</label>
    <input type="text" id="time" name="time" required>
    <label for="config">کانفیگ:</label>
    <input type="text" id="config" name="config" required>
    <label for="config_qr">فایل QR کانفیگ:</label>
    <input type="file" id="config_qr" name="config_qr" accept="image/*" required>
    <input type="submit" value="ذخیره">
  </form>
  <?php if (!empty($message)): ?>
    <div class="message"><?php echo $message; ?></div>
  <?php endif; ?>
</body>
</html>