<?php
// ======================================================= //
function createClient($username, $limit, $expire_data, $token, $url)
{
    $activeInbounds = getActiveInbounds($url, $token);
    if (empty($activeInbounds)) return [false, 'No active inbounds found'];
    $proxies = [];
    foreach ($activeInbounds as $protocol => $tags) 
    {
        switch ($protocol) 
        {
            case 'vless':
            case 'vmess':
            case 'trojan':
                $proxies[$protocol] = [
                    'id' => bin2hex(random_bytes(16))
                ];
                break;

            case 'shadowsocks':
                $proxies[$protocol] = [
                    'method' => 'aes-128-gcm',
                    'password' => bin2hex(random_bytes(8))
                ];
                break;
        }
    }
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url . '/api/user');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
        'Authorization: Bearer ' . $token,
        'Content-Type: application/json'
    ]);
    $body = [
        'username' => $username,
        'expire' => $expire_data,
        'data_limit' => $limit,
        'data_limit_reset_strategy' => 'no_reset',
        'inbounds' => $activeInbounds,
        'proxies' => $proxies
    ];
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
    $response = curl_exec($ch);
    $response = json_decode($response, true);
    curl_close($ch);
    return isset($response['subscription_url']) ? [true, $response['subscription_url']] : [false, $response['detail'] ?? 'Unknown error'];
}
// ======================================================= //
function createConfig($invoice_id) 
{
    global $db;
    $invoice  = mysqli_fetch_assoc($db->query("SELECT * FROM `invoices` WHERE `id` = '$invoice_id'"));
    $panel    = mysqli_fetch_assoc($db->query("SELECT * FROM `servers` WHERE `name` = '{$invoice['category']}'"));
    $login    = mysqli_fetch_assoc($db->query("SELECT * FROM `tokens` WHERE `panel` = 'مرزبان'"));
    $userName = random() . '_' . $invoice['user_id'];
    $time     = time() + (convertDaysToTimestamp($invoice['time']));
    $traffick = convertGigabytesToBytes($invoice['traffick']);
    $config   = createClient($userName, $traffick, $time, $login['token'], $panel['url']);
    if ($config[0] === true) 
    {
        if (filter_var($config[1], FILTER_VALIDATE_URL)) $link = $config[1];
        else $link = $panel['url'] . $config[1];
        $text = "✅ کانفیگ شما با موفقیت ساخته شد\n🪪 اسم کانفیگ : {$userName}\n❤️ برای استفاده کافی است روی لینک زیر کلیک کنید\n\n👤 در صورت بروز مشکل با پشتیبانی در ارتباط باشید\n\n🔗 {$link}";
    }
    else
    {
        $text = false;
        error_log(json_encode($config));
    }
    return $text;
}
// ======================================================= //
function createConfigTest($serverName)
{
    global $db;
    $panel    = mysqli_fetch_assoc($db->query("SELECT * FROM `servers` WHERE `name` = '{$serverName}'"));
    $login    = mysqli_fetch_assoc($db->query("SELECT * FROM `tokens` WHERE `panel` = 'مرزبان'"));
    $userName = random() . '_100000000';
    $time     = time() + 10800;
    $traffick = convertGigabytesToBytes(0.5);
    $config   = createClient($userName, $traffick, $time, $login['token'], $panel['url']);
    if ($config[0] === true) 
    {
        if (filter_var($config[1], FILTER_VALIDATE_URL)) $link = $config[1];
        else $link = $panel['url'] . $config[1];
        $text = "✅ کانفیگ شما با موفقیت ساخته شد\n\n❤️ برای استفاده کافی است روی لینک زیر کلیک کنید\n\n👤 در صورت بروز مشکل با پشتیبانی در ارتباط باشید\n\n🔗 {$link}";
    }
    else
    {
        $text = false;
        error_log(json_encode($config));
    }
    return $text;
}
// ======================================================= //
function getActiveInbounds($url, $token)
{
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url . '/api/inbounds',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Accept: application/json',
            'Authorization: Bearer ' . $token
        ]
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($response, true);
    $result = [];
    if (!is_array($data)) return [];
    foreach ($data as $protocol => $inbounds) 
    {
        if (!is_array($inbounds)) continue;
        foreach ($inbounds as $inbound) 
        {
            if (isset($inbound['tag'])) $result[$protocol][] = $inbound['tag'];
        }
    }
    return $result;
}